/*This SAS code reads in the dataset and then uses the means procedure
to produce the information plotted in the Figures of Chapter 1. */

Data Chapter2;
input incidents permissive apprehension count;
DATALINES;
0	2	1	113
0	2	0	127
0	1	1	108
0	1	0	176
0	0	1	55
0	0	0	175
1	2	1	148
1	2	0	131
1	1	1	84
1	1	0	126
1	0	1	46
1	0	0	94
2	2	1	170
2	2	0	134
2	1	1	65
2	1	0	70
2	0	1	26
2	0	0	30
;

data chapter2; set chapter2;

Title 'Data for Figure 2.1.';
proc means N Mean; var apprehension;
	Class permissive;
	Freq count;
Run;

Title 'Data for Figure 2.2.';
proc means N Mean; var apprehension;
	Class incidents;
	Freq count;
Run;

Title 'Data for Figure 2.3.';
proc means N Mean; var apprehension;
	Class permissive incidents;
	Freq count;
Run;


/* To obtain parameter estimates and their statistical significance, the following SAS Code 
applies the Glimmix procedure assuming that apprehension requires a binomial distribution and
a logit link. 
	In the Proc Glimmix statement the OR requests odds ratios. The pq option on the information
criteria (ic option) includes penalties in the calculation of the AIC and BIC for the number 
of fixed-effects parameters in the model.  
	In the model statement and in the lsmeans statement cl requests confidence limits.
	In the least-squares means (lsmeans) statements the ilink option converts the logit-scale parameters
to proportions; the pdiff option request the differences between the means and their significance.
	The output includes the predicted values and residuals on the proportion scale (ilink) and on the 
	logit scale	(noilink). These Table numbers are coordinated to those in the article cited
	after this code.
*/


Title ' Model 3b: No cross-level interaction pq option no random intercepts no random residual';

PROC glimmix data = chapter2 OR ic = pq;
	Freq count;
	Class incidents permissive;
	Model apprehension = permissive incidents /s cl dist = binomial link = logit;
	*random intercept / type= un subject = incidents g s;
	*random _residual_;
	lsmeans permissive / ilink pdiff cl;
	lsmeans incidents/ ilink pdiff cl;
	output out=model3b
	pred(blup ilink)= pilink   pred(blup noilink) = pnoilink
	resid(blup ilink)=rilink  resid(blup noilink) = rnoilink; 
run;

data model33b; set model3b;
Title 'Model 3b binomial no random effects';
	proc print; 
run;

/* Model 4a is similar to Model 3b but it includes the cross-level contextual effect parameter.*/

Title 'Model 4a binomial no random effects, intercepts + permissive|incidents, pq option no type un';
PROC glimmix  DATA= chapter2 or ic = pq; 
	freq count;
	class permissive incidents;
	model apprehension = permissive|incidents /s cl dist = binomial link = logit;
	*random intercept / type= un subject = incidents g s;
	*random _residual_;
	lsmeans permissive|incidents/ ilink or pdiff cl;
	output out=model4
	pred(blup ilink)= pilink   pred(blup noilink) = pnoilink
	resid(blup ilink)=rilink  resid(blup noilink) = rnoilink; 
run;

data model41; set model4;
Title 'Model 4 binomial with interaction but without random intercepts ';
proc print; run;
run;

/*For explication of these Glimmix models see Robert B. Smith, Chapter 9, The Academic Mind Revisted:
Contextual Analysis via Multilevel Modeling.  In V. Capecchi et al. (eds.) Applications of 
Mathematics in Models, Artificial Neural Networks and Arts.  Springer, 2010.
The syntax in this file is copyright by Robert B. Smith  2011.*/
